Scriptname _SLSubmitEscapeEffect extends ActiveMagicEffect   

import game

_SLSubmitConfig Property _SLConfig auto
_SLSubmitFunctions Property _SLFunctions auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto

GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
SPELL Property _SLSubmitBoundEnd  Auto
GlobalVariable Property BoundGlobal  Auto
GlobalVariable Property EscapeBonus  Auto
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
SPELL Property _SLSubmitAssign  Auto  
SPELL Property _SLSubmitSurrender Auto  
Perk Property QuickHands Auto
Actor Property PlayerRef Auto
ZadLibs Property Libs Auto
Spell Property Shock Auto

Event OnEffectStart(actor Target, actor Caster)

; // Code for the success algorithm
	;Debug.SendAnimationEvent(PlayerRef, "IdleHandsBehindBack")
	_SLScene.WRT(0.25)
	;Debug.SendAnimationEvent(PlayerRef, "IdleBoundKneesStart")
	_SLQuest.EscapeChance()
; // Code for what happens on success
	If (SuccessChance.GetValue() >= SuccessRoll.GetValue())
		If(_SLConfig.debugActive)
			Debug.Notification(SuccessChance.GetValue() + "% success chance, rolled under with " + SuccessRoll.GetValue() + "%.  Success!")
		EndIf
		AdvanceSkill("Lockpicking", (_SLConfig.Escape + 1.0))
		BoundGlobal.SetValue(0)
		_SLFunctions.DoFadeOut()
		_SLSubmitBoundEnd.Cast(PlayerRef)
	Else
; // Code for what happens on failure
		If(_SLConfig.debugActive)
			Debug.Notification(SuccessChance.GetValue() + "% success chance, rolled too high with" + SuccessRoll.GetValue() + "%.  Failure!")
		EndIf
		
		If (_SLConfig.Escape == 1) 
			EscapeBonus.SetValue(EscapeBonus.GetValue() + 1.0)
			AdvanceSkill("Lockpicking", 0.25)
		ElseIf (_SLConfig.Escape == 2) 
			EscapeBonus.SetValue(EscapeBonus.GetValue() + 0.8)
			AdvanceSkill("Lockpicking", 0.15)
		ElseIf (_SLConfig.Escape == 3) 
			EscapeBonus.SetValue(EscapeBonus.GetValue() + 0.5)
			AdvanceSkill("Lockpicking", 0.10)
		ElseIf (_SLConfig.Escape == 4) 
			EscapeBonus.SetValue(EscapeBonus.GetValue() + 0.3)
			AdvanceSkill("Lockpicking", 0.05)
		ElseIf (_SLConfig.Escape == 5) 
			EscapeBonus.SetValue(EscapeBonus.GetValue() + 0.1)
		EndIf
		
		Shock.RemoteCast(PlayerRef, PlayerRef, PlayerRef)
		Libs.SexlabMoan(PlayerRef,-1)

		
		_SLScene.WRT(0.1)
		If ((PlayerRef.HasPerk(QuickHands) && (SuccessRoll.GetValue() - SuccessChance.GetValue()) >= (50 + _SLConfig.CDifficulty)) || (!PlayerRef.HasPerk(QuickHands) && (SuccessRoll.GetValue() - SuccessChance.GetValue()) >= (25 + _SLConfig.CDifficulty)))
			If (_SLConfig.PunishmentActive)
				If(_SLConfig.debugActive)
					Debug.Notification("Your attempted escape may not have gone unnoticed...")
				EndIf
				_SLSubmitSurrenderGlobal.SetValue(1)
				_SLSubmitAssign.Cast(PlayerRef)
				_SLSubmitSurrender.Cast(PlayerRef)
			EndIf
		EndIf
	EndIf
EndEvent